<?

function console_log($data){
  echo '<script>';
  echo 'console.log('.json_encode( $data ).')';
  echo '</script>';
}

function formatDate($n){
	$data = date('d/m/Y', strtotime($n));
	return $data;
}

function formatGrau($n){
	switch ($n) {
		case 'T':
			return 'Tecnólogo';
			break;
		case 'B':
			return 'Bacharelado';
			break;
		case 'L':
			return 'Licenciatura';
			break;
		case 'C':
			return 'Curso sequencial';
			break;
		case 'S':
			return 'Curso sequencial';
			break;
	}	
}

function formatDocs($n){
		switch ($n) {
		case '2':
			return 'Outros';
			break;
		case '1':
			return 'DocumentoIdentidadeDoAluno';
			break;
		case '5':
			return 'ProvaConclusaoEnsinoMedio';
			break;
		case '6':
			return 'ProvaConclusaoEnsinoMedio';
			break;
		case '46':
			return 'ProvaColacao';
			break;
		case '3':
			return 'CertidaoNascimento';
			break;
		case '3':
			return 'CertidaoCasamento';
			break;
		default:
			return 'Outros';
			break;
	}		
}

function formatModal($n){
	switch ($n) {
		case 'E':
			return 'EAD';
			break;
		case 'P':
			return 'Presencial';
			break;
	}	
}

function formatGender($n){
	switch ($n) {
		case 'F':
			return 'Feminino';
			break;
		case 'M':
			return 'Masculino';
			break;
	}	
}

function B64Encode($LocalArquivo,$NomeArquivo,$HashArquivo){
	$arquivo = $HashArquivo;
	$path = preg_replace("/(\d{4})(\d{2})(\d{2})/", "/home/unimaiseadcom/arquivos/a$1/m$2/d$3/", $LocalArquivo);
	$BS64 = chunk_split(base64_encode(file_get_contents($path.$arquivo)));
	return $BS64;
}

function formataData($n){
	$data = date('d/m/Y H:i', strtotime($n));
	return $data;
}

class User {
	private $db;
	function __construct($mysql_conn)
	{
		$this->db = $mysql_conn;
	}

	// IES Emissora


	public function count_answers($q, $a){
		console_log($q.' : '.$a);
		$stmt = $this->db->prepare('SELECT numero_questao, opcao_resposta, data_cadastro, count(opcao_resposta) as resposta from cpa_pesquisa where data_cadastro BETWEEN :str AND :end and numero_questao = :qst and opcao_resposta = :anw group by opcao_resposta ORDER BY opcao_resposta DESC limit 1;');
		$stmt->bindValue( ':qst', $q);
		$stmt->bindValue( ':anw', $a);
		$stmt->bindValue( ':str', '2023-11-01');
		$stmt->bindValue( ':end', '2024-03-31');
		$stmt->execute();
		$resultado=$stmt->fetch(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function write_answers($q){
		$stmt = $this->db->prepare('SELECT numero_questao, texto_resposta, data_cadastro from cpa_pesquisa where data_cadastro BETWEEN :str AND :end and numero_questao = :qst ORDER BY texto_resposta ASC;');
		$stmt->bindValue( ':qst', $q);
		$stmt->bindValue( ':str', '2023-11-01');
		$stmt->bindValue( ':end', '2024-03-31');
		$stmt->execute();
		$resultado=$stmt->fetchall(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function GetAluno($cod){
		$stmt = $this->db->prepare("select aluno.codigo_aluno, aluno.nome_aluno, aluno.sexo_aluno, aluno.cpf_aluno, aluno.rg_aluno, aluno.rg_orgao_expedidor, aluno.rg_uf, aluno.codigo_pais_nacionalidade, aluno.data_nasc_aluno, aluno.nome_mae, aluno.nome_pai from aluno where aluno.cpf_aluno = :cod LIMIT 1");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetch(PDO::FETCH_ASSOC);
		return $resultado;
	}
	
	public function GetInscricao($cod){
		$stmt = $this->db->prepare("select inscricao.codigo_inscricao, inscricao.codigo_aluno, inscricao.codigo_curso, inscricao.data_inscricao, curso.codigo_curso, curso.nome_curso from inscricao join curso on curso.codigo_curso = inscricao.codigo_curso where inscricao.codigo_aluno = :cod");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchall(PDO::FETCH_ASSOC);
		return $resultado;
	}
	
	public function GetNotas($cod){
		$stmt = $this->db->prepare("select notas_ead.codigo_notas_ead, notas_ead.codigo_inscricao, notas_ead.codigo_disciplina, notas_ead.nota_ead, notas_ead_sub.codigo_notas_ead,notas_ead_sub.codigo_notas_ead_sub, notas_ead_sub.codigo_notas_ead, notas_ead_sub.nota_ead as nota_ead_sub, disciplina.codigo_disciplina, disciplina.nome_disciplina from notas_ead join notas_ead_sub on notas_ead_sub.codigo_notas_ead = notas_ead.codigo_notas_ead join disciplina on disciplina.codigo_disciplina = notas_ead.codigo_disciplina where notas_ead.codigo_inscricao = :cod");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchall(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function UpdateNotas($cod, $val){
		$stmt = $this->db->prepare("update notas_ead_sub set nota_ead=:val where codigo_notas_ead_sub=:cod");
		$stmt->bindValue( ':cod', $cod);
		$stmt->bindValue( ':val', $val);
		$stmt->execute();
		return $stmt;
	}



	public function dadosDiplomadoList($crs){
		$stmt = $this->db->prepare("select inscricao.codigo_inscricao, inscricao.codigo_aluno, inscricao.codigo_curso, inscricao.data_inscricao, aluno.nome_aluno, aluno.rg_aluno, aluno.rg_orgao_expedidor, aluno.rg_uf from inscricao join aluno on aluno.codigo_aluno = inscricao.codigo_aluno where inscricao.codigo_curso = :crs and inscricao.situacao = 'CS' order by aluno.nome_aluno asc");
		$stmt->bindValue( ':crs', $crs);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		$student_list = '';		
		foreach ($resultado as $row => $data) {
			$codigo_inscricao = $data['codigo_inscricao'];
			$codigo_aluno = $data['codigo_aluno'];
			$codigo_curso = $data['codigo_curso'];
			$data_inscricao = $data['data_inscricao'];
			$nome_aluno = $data['nome_aluno'];
			$naturalidade = strlen($data['naturalidade'])? $data['naturalidade'] : '';
			$naturalidade_nome_municipio_estrang = '';
			$rg_aluno = is_numeric($data['rg_aluno'])? $data['rg_aluno'] : '';
			$rg_orgao_expedidor = $data['rg_orgao_expedidor'];
			$rg_uf = $data['rg_uf'];
			$naturalidade_codigo_municipio = '';
			$naturalidade_nome_municipio = '';
			$diplomadoAuth = $this->dadosDiplomadoAuth($codigo_aluno,$codigo_inscricao);
			if(empty($diplomadoAuth)){
				$diplomadoInsert = $this->dadosDiplomadoInsert($codigo_inscricao, $nome_aluno, $naturalidade_codigo_municipio, $naturalidade_nome_municipio, $naturalidade, $naturalidade_nome_municipio_estrang, $rg_aluno, $rg_orgao_expedidor, $rg_uf, $codigo_aluno);
			}		
			$student = $this->dadosDiplomadoSelect($codigo_aluno,$codigo_inscricao);
			$student_list .= '<tr class="align-middle"><th scope="row">'.$data['codigo_inscricao'].'</th><td>'.$student['nome_aluno'].'</td><td class="text-center">'.$student['cpf_aluno'].'</td><td class="text-center">'.formataData($data['data_inscricao']).'</td><td class="text-end"><button class="button-inscricao border-0 bg-transparent icon-student py-0 align-middle" data-inscricao="'.$data['codigo_inscricao'].'"></button></td></tr>';
		}
		if(!empty($student_list)){
			return $student_list;
		}else{
			return '<tr><td colspan="5">Nenhum aluno encontrado</td></tr>';
		}
	}

	// Incrições
	
	public function registry($inc){
		$stmt = $this->db->prepare("select codigo_inscricao,codigo_aluno,codigo_curso,egresso,data_conclusao,data_inscricao from inscricao where codigo_inscricao = :inc");
		$stmt->bindValue( ':inc', $inc);
		$stmt->execute();
		$resultado=$stmt->fetch(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function discLib($inc){
		$stmt = $this->db->prepare("select codigo_liberacao_discip,codigo_inscricao,codigo_disciplina,data_liberacao,codigo_usuario_alteracao,data_alteracao,carga_horaria from inscricao where codigo_inscricao = :inc");
		$stmt->bindValue( ':inc', $inc);
		$stmt->execute();
		$resultado=$stmt->fetch(PDO::FETCH_ASSOC);
		return $resultado;
	}
	
	public function state($cod){
		if($cod != 0){
			$stmt = $this->db->prepare("select estado.sigla_estado,estado.nome_estado,diploma_mec_diplomado.codigo_aluno,diploma_mec_diplomado.naturalidade_uf from estado join diploma_mec_diplomado on diploma_mec_diplomado.codigo_aluno = :cod order by estado.nome_estado asc");
			$stmt->bindValue(':cod', $cod);	
		}else{
			$stmt = $this->db->prepare("select sigla_estado,nome_estado from estado order by nome_estado asc");
		}
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		$state_option = '<option></option>';
		foreach ($resultado as $row => $data) {
			$selected = ($data['sigla_estado'] == $data['naturalidade_uf'])? 'selected' : '';
			$state_option .= '<option value="'.$data['sigla_estado'].'" '.$selected.'>'.$data['nome_estado'].'</option>';
		}
		return $state_option;
	}
	
	public function county($cod){
		$stmt = $this->db->prepare("select codigo_municipio,nome_municipio,sigla_estado from municipio where sigla_estado = :cod order by nome_municipio asc");
		$stmt->bindValue(':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		$county_option = '<option></option>';
		foreach ($resultado as $row => $data) {
			$county_option .= '<option value="'.$data['codigo_municipio'].'">'.$data['nome_municipio'].'</option>';
		}
		return $county_option;
	}

	// Diversos

	public function country($cod){
		$stmt = $this->db->prepare("select codigo_pais,nome_pais from pais where codigo_pais = :cod");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetch(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function certificate($cod){
		$stmt = $this->db->prepare("select id_diplomado,nome_social_diplomado,naturalidade_codigo_municipio,naturalidade_nome_municipio,naturalidade_uf,codigo_diplomado,naturalidade_nome_municipio_estrang,rg_orgao_expedidor,rg_uf,codigo_aluno,codigo_inscricao,forma_acesso from diploma_mec_diplomado where codigo_aluno = :cod");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetch(PDO::FETCH_ASSOC);
		return $resultado;
	}
	
	// Historico
	public function historic($cod){	
		$stmt = $this->db->prepare("SELECT CASE curso.tipo_graduacao WHEN 'B' THEN 'Bacharelado'WHEN 'F' THEN 'Formação Pedagógica'WHEN 'L' THEN 'Licenciatura'WHEN 'S' THEN 'Segunda Licenciatura'WHEN 'T' THEN 'Tecnólogo'ELSE curso.tipo_graduacao END HistoricoEscolarNomeParaAreas, diploma_mec_curso.codigo_curso_emec AS HistoricoEscolarCodigoCurriculo, inscricao.data_conclusao AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarDataEmissaoHistorico, '10:00' AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarHoraEmissaoHistorico, curso.carga_horaria_total AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarCargaHorariaCursoIntegralizadaHoraAula, CONCAT(DATE_FORMAT(inscricao.data_conclusao, '%Y'),'/',IF(DATE_FORMAT(inscricao.data_conclusao, '%m')<6,'1','2')) AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarSituacaoAtualDiscentePeriodoLetivo, 'Formado' AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarSituacaoAtualDiscenteSituacaoDiscente, inscricao.data_conclusao AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarSituacaoAtualDiscenteSituacaoDiscenteFormadoDataConclusaoCurso, inscricao.data_conclusao AS DadosDiplomaDataConclusao, diploma_mec_curso.nome_curso_mec AS DadosDiplomaDadosCursoNomeCurso, diploma_mec_curso.nome_habilitacao_mec AS DadosDiplomaDadosCursoNomeHabilitacao, diploma_mec_curso.codigo_curso_emec AS DadosDiplomaDadosCursoCodigoCursoEMEC, CASE curso.tipo_graduacao WHEN 'B' THEN 'Bacharelado'WHEN 'F' THEN 'Formação Pedagógica'WHEN 'L' THEN 'Licenciatura'WHEN 'S' THEN 'Segunda Licenciatura'WHEN 'T' THEN 'Tecnólogo'ELSE curso.tipo_graduacao END DadosDiplomaDadosCursoTituloConferidoOutroTitulo, CASE curso.tipo_graduacao WHEN 'B' THEN 'Bacharelado'WHEN 'F' THEN 'Formação Pedagógica'WHEN 'L' THEN 'Licenciatura'WHEN 'S' THEN 'Segunda Licenciatura'WHEN 'T' THEN 'Tecnólogo'ELSE curso.tipo_graduacao END DadosDiplomaDadosCursoGrauConferido, CASE curso.tipo_curso WHEN 'E' THEN 'EAD'WHEN 'P' THEN 'Presencial'ELSE curso.tipo_curso END DadosDiplomaDadosCursoModalidade, diploma_mec_tipo_ato.tipo_ato AS DadosDiplomaDadosCursoAutorizacaoTipo, diploma_mec_curso.codigo_autorizacao AS DadosDiplomaDadosCursoAutorizacaoNumero, diploma_mec_ato_regulatorio.veiculo_publicacao AS DadosDiplomaDadosCursoAutorizacaoVeiculoPublicacao, diploma_mec_ato_regulatorio.data_ato AS DadosDiplomaDadosCursoAutorizacaoData, diploma_mec_ato_regulatorio.data_publicacao AS DadosDiplomaDadosCursoAutorizacaoDataPublicacao, diploma_mec_ato_regulatorio.secao_publicacao AS DadosDiplomaDadosCursoAutorizacaoSecaoPublicacao, diploma_mec_ato_regulatorio.pagina_publicacao AS DadosDiplomaDadosCursoAutorizacaoPaginaPublicacao, diploma_mec_ato_regulatorio.numero_dou AS DadosDiplomaDadosCursoAutorizacaoNumeroDOU, diploma_mec_tipo_ato.tipo_ato AS DadosDiplomaDadosCursoReconhecimentoTipo, diploma_mec_ato_regulatorio.numero_ato AS DadosDiplomaDadosCursoReconhecimentoNumero, diploma_mec_ato_regulatorio.veiculo_publicacao AS DadosDiplomaDadosCursoReconhecimentoVeiculoPublicacao, diploma_mec_ato_regulatorio.data_publicacao AS DadosDiplomaDadosCursoReconhecimentoDataPublicacao, diploma_mec_ato_regulatorio.secao_publicacao AS DadosDiplomaDadosCursoReconhecimentoSecaoPublicacao, diploma_mec_ato_regulatorio.pagina_publicacao AS DadosDiplomaDadosCursoReconhecimentoPaginaPublicacao, diploma_mec_ato_regulatorio.numero_dou AS DadosDiplomaDadosCursoReconhecimentoNumeroDOU, diploma_mec_endereco.endereco_logradouro AS DadosDiplomaDadosCursoEnderecoLogradouro, diploma_mec_endereco.endereco_numero AS DadosDiplomaDadosCursoEnderecoNumero, diploma_mec_endereco.endereco_complemento AS DadosDiplomaDadosCursoEnderecoComplemento, diploma_mec_endereco.endereco_bairro AS DadosDiplomaDadosCursoEnderecoBairro, diploma_mec_endereco.endereco_cep AS DadosDiplomaDadosCursoEnderecoCEP, diploma_mec_endereco.endereco_codigo_municipio AS DadosDiplomaDadosCursoEnderecoCodigoMunicipio, diploma_mec_endereco.endereco_nome_municipio AS DadosDiplomaDadosCursoEnderecoNomeMunicipio, diploma_mec_endereco.endereco_uf AS DadosDiplomaDadosCursoEnderecoUF, professor.nome_professor AS DocenteNome, CASE professor.titulacao_professor WHEN 'P' THEN 'Pós-Doutor'WHEN 'E' THEN 'Especialista'WHEN 'M' THEN 'Mestre'WHEN 'D' THEN 'Doutor'END DocenteTitulacao, CONCAT(DATE_FORMAT(inscricao.data_conclusao, '%Y'),'/',IF(DATE_FORMAT(inscricao.data_conclusao, '%m')<6,'1','2')) AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularSituacaoDiscentePeriodoLetivo, 'FORMADO' AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularSituacaoDiscenteSituacaoDiscente FROM inscricao JOIN curso ON curso.codigo_curso = inscricao.codigo_curso JOIN diploma_mec_curso ON diploma_mec_curso.codigo_curso = inscricao.codigo_curso JOIN diploma_mec_ato_regulatorio ON diploma_mec_ato_regulatorio.codigo_ato_regulatorio = diploma_mec_curso.codigo_autorizacao JOIN diploma_mec_tipo_ato ON diploma_mec_tipo_ato.codigo_tipo_ato = diploma_mec_ato_regulatorio.codigo_tipo_ato JOIN professor ON professor.codigo_professor = curso.codigo_professor_responsavel JOIN diploma_mec_dados_ies ON diploma_mec_dados_ies.codigo_dados_ies = diploma_mec_curso.codigo_dados_ies JOIN diploma_mec_endereco ON diploma_mec_endereco.codigo_endereco = diploma_mec_dados_ies.codigo_endereco WHERE inscricao.codigo_inscricao = :cod AND inscricao.codigo_inscricao_situacao = 7");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function curriculum($cod){
		$stmt = $this->db->prepare("SELECT RIGHT(diploma_mec_curso.codigo_curso_emec, 4) AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaCodigo
		, disciplina.nome_disciplina AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaDisciplina
		, notas_frequencia.nota_final AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaNota
		, notas_frequencia.frequencia AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaFrequencia
		, curso_discip.carga_horaria AS HoraAula
		, IF(notas_frequencia.nota_final >= 6, 'Aprovado', 'Reprovado') AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaSituacaoDisciplina
		, CONCAT(DATE_FORMAT(notas_frequencia.data_atualizacao, '%Y'),'/', IF(DATE_FORMAT(notas_frequencia.data_atualizacao, '%m')<6,'1','2')) AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaPeriodo
		, CASE curso.tipo_curso WHEN 'E' THEN 'EAD'WHEN 'P' THEN 'Presencial'ELSE curso.tipo_curso END Etiqueta
		, professor.nome_professor AS DocenteNome
		, CASE professor.titulacao_professor WHEN 'P' THEN 'Doutorado'WHEN 'E' THEN 'Especialização'WHEN 'M' THEN 'Mestrado'WHEN 'D' THEN 'Doutorado' END DocenteTitulacao
		, curso_discip.carga_horaria AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCargaHoraria
		, diploma_mec_diplomado.naturalidade_uf AS DadosDiplomaDiplomadoNaturalidadeUF
		, diploma_mec_diplomado.naturalidade_codigo_municipio AS DadosDiplomaDiplomadoNaturalidadeCodigoMunicipio
		, diploma_mec_diplomado.naturalidade_nome_municipio AS DadosDiplomaDiplomadoNaturalidadeNomeMunicipio
		, diploma_mec_diplomado.forma_acesso AS RegistroReqdadosPrivadosDiplomadoHistoricoEscolarIngressoCursoFormaAcesso
		FROM inscricao
		JOIN curso ON curso.codigo_curso = inscricao.codigo_curso
		JOIN notas_frequencia ON notas_frequencia.codigo_inscricao = inscricao.codigo_inscricao
		JOIN curso_discip ON curso_discip.codigo_disciplina = notas_frequencia.codigo_disciplina AND curso_discip.codigo_curso = inscricao.codigo_curso
		JOIN disciplina ON disciplina.codigo_disciplina = notas_frequencia.codigo_disciplina
		JOIN professor ON professor.codigo_professor = disciplina.codigo_professor_responsavel
		JOIN diploma_mec_curso ON diploma_mec_curso.codigo_curso = inscricao.codigo_curso
		JOIN diploma_mec_diplomado ON diploma_mec_diplomado.codigo_aluno = inscricao.codigo_aluno
		WHERE inscricao.codigo_inscricao = :cod AND inscricao.codigo_inscricao_situacao = 7 
		GROUP BY notas_frequencia.codigo_disciplina ORDER BY notas_frequencia.numero_semestre, disciplina.nome_disciplina");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function curriculumT($cod){	
		$stmt = $this->db->prepare("SELECT RIGHT(diploma_mec_curso.codigo_curso_emec, 4) AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaCodigo
		, disciplina.nome_disciplina AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaDisciplina
		, notas_frequencia.nota_final AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaNota
		, curso_discip.carga_horaria AS HoraAula
		, IF(notas_frequencia.nota_final >= 6, 'Aprovado', 'Reprovado') AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaSituacaoDisciplina
		, DATE_FORMAT(notas_frequencia.data_atualizacao, '%Y') AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularDisciplinaCursadaPeriodo
		, professor.nome_professor AS DocenteNome
		, CASE professor.titulacao_professor WHEN 'P' THEN 'Doutorado'WHEN 'E' THEN 'Especialização'WHEN 'M' THEN 'Mestrado'WHEN 'D' THEN 'Doutorado' END DocenteTitulacao
		, CASE curso.tipo_curso WHEN 'E' THEN 'EAD'WHEN 'P' THEN 'Presencial'ELSE curso.tipo_curso END Etiqueta
		, diploma_mec_diplomado.naturalidade_uf AS DadosDiplomaDiplomadoNaturalidadeUF
		, diploma_mec_diplomado.naturalidade_codigo_municipio AS DadosDiplomaDiplomadoNaturalidadeCodigoMunicipio
		, diploma_mec_diplomado.naturalidade_nome_municipio AS DadosDiplomaDiplomadoNaturalidadeNomeMunicipio
		, diploma_mec_diplomado.forma_acesso AS RegistroReqdadosPrivadosDiplomadoHistoricoEscolarIngressoCursoFormaAcesso
		FROM inscricao
		JOIN curso ON curso.codigo_curso = inscricao.codigo_curso
		JOIN notas_frequencia ON notas_frequencia.codigo_inscricao = inscricao.codigo_inscricao
		JOIN disciplina ON disciplina.codigo_disciplina = notas_frequencia.codigo_disciplina
		JOIN curso_discip ON curso_discip.codigo_disciplina = notas_frequencia.codigo_disciplina AND curso_discip.codigo_curso = inscricao.codigo_curso
		JOIN professor ON professor.codigo_professor = disciplina.codigo_professor_responsavel
		JOIN diploma_mec_curso ON diploma_mec_curso.codigo_curso = inscricao.codigo_curso
		JOIN diploma_mec_diplomado ON diploma_mec_diplomado.codigo_aluno = inscricao.codigo_aluno
		WHERE inscricao.codigo_inscricao = :cod
		AND inscricao.codigo_inscricao_situacao = 7 
		GROUP BY notas_frequencia.codigo_disciplina ORDER BY notas_frequencia.numero_semestre, disciplina.nome_disciplina");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}


	// DIPLOMA API
	
	public function diplomaxmlInsert($codigo_aluno, $codigo_inscricao, $id_diploma, $situacao_diploma, $documentacao, $tipo_diploma){
	    $stmt = $this->db->prepare("insert into diploma_mec_diploma_xml(codigo_aluno, codigo_inscricao, codigo_diploma, situacao_diploma, arquivo_diploma, tipo_diploma) values (:codigo_aluno, :codigo_inscricao, :id_diploma, :situacao_diploma, :documentacao, :tipo_diploma)");
 		$stmt->bindparam( ':codigo_aluno', $codigo_aluno );
		$stmt->bindparam( ':codigo_inscricao', $codigo_inscricao );
		$stmt->bindparam( ':id_diploma', $id_diploma );
		$stmt->bindparam( ':situacao_diploma', $situacao_diploma );
		$stmt->bindparam( ':documentacao', $documentacao );
		$stmt->bindparam( ':tipo_diploma', $tipo_diploma );
		$stmt->execute();
		return $this->db->lastInsertId();
	}	

	public function dadosDiplomaSelect($codigo_aluno, $codigo_inscricao, $tipo_diploma){
	    $stmt = $this->db->prepare("select codigo_xml_diploma, codigo_aluno, codigo_inscricao, codigo_diploma, situacao_diploma, arquivo_diploma, registro_diploma, tipo_diploma  from diploma_mec_diploma_xml where codigo_aluno = :codigo_aluno and codigo_inscricao = :codigo_inscricao and tipo_diploma = :tipo_diploma limit 1");
 		$stmt->bindparam( ':codigo_aluno', $codigo_aluno );
		$stmt->bindparam( ':codigo_inscricao', $codigo_inscricao );
		$stmt->bindparam( ':tipo_diploma', $tipo_diploma );
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}
	
	public function dadosXMLSelect($cod){
	    $stmt = $this->db->prepare("select codigo_diploma, arquivo_diploma from diploma_mec_diploma_xml where codigo_xml_diploma = :cod limit 1");
 		$stmt->bindparam( ':cod', $cod );
		$stmt->execute();
		$resultado=$stmt->fetch(PDO::FETCH_ASSOC);
		return $resultado;
	}
	
	public function dadosAlunoGenitor($cod){	
	    $stmt = $this->db->prepare("SELECT aluno.cpf_aluno AS DadosDiplomaDiplomadoID
		, aluno.naturalidade AS DadosDiplomaDiplomadoNaturalidade
		, aluno.naturalidade AS DadosDiplomaDiplomadoNaturalidade
		, aluno.naturalidade AS DadosDiplomaDiplomadoNaturalidade		
		, aluno.nome_aluno AS DadosDiplomaDiplomadoNome, pais.nome_pais AS DadosDiplomaDiplomadoNacionalidade, aluno.codigo_aluno AS DiplomadoCodigo, aluno.sexo_aluno AS DadosDiplomaDiplomadoSexo, aluno.data_nasc_aluno AS DadosDiplomaDiplomadoDataNascimento, aluno.rg_aluno AS DadosDiplomaDiplomadoRGNumero, aluno.rg_orgao_expedidor AS DadosDiplomaDiplomadoRGOrgaoExpedidor, aluno.rg_uf AS DadosDiplomaDiplomadoRGUF, aluno.naturalidade AS DadosDiplomaDiplomadoNaturalidadeUF, aluno.nome_mae AS RegistroReqDadosPrivadosDiplomadoFiliacaoGenitorNome, 'F' AS RegistroReqDadosPrivadosDiplomadoFiliacaoGenitorSexo FROM inscricao JOIN aluno ON aluno.codigo_aluno = inscricao.codigo_aluno LEFT JOIN pais ON pais.codigo_pais = aluno.codigo_pais_nacionalidade WHERE inscricao.codigo_inscricao = :cod AND inscricao.codigo_inscricao_situacao = 7;");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function dadosCursoHist($cod){	
	    $stmt = $this->db->prepare("SELECT CASE curso.tipo_graduacao WHEN 'B' THEN 'Bacharelado'WHEN 'F' THEN 'Formação Pedagógica'WHEN 'L' THEN 'Licenciatura'WHEN 'S' THEN 'Segunda Licenciatura'WHEN 'T' THEN 'Tecnólogo'ELSE curso.tipo_graduacao END HistoricoEscolarNomeParaAreas, inscricao.data_inscricao AS RegistroReqdadosPrivadosDiplomadoHistoricoEscolarIngressoCursodata , diploma_mec_curso.codigo_curso_emec AS HistoricoEscolarCodigoCurriculo, inscricao.data_conclusao AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarDataEmissaoHistorico, '10:00' AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarHoraEmissaoHistorico, curso.carga_horaria_total AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarCargaHorariaCursoIntegralizadaHoraAula, CONCAT(DATE_FORMAT(inscricao.data_conclusao, '%Y'),'/',IF(DATE_FORMAT(inscricao.data_conclusao, '%m')<6,'1','2')) AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarSituacaoAtualDiscentePeriodoLetivo, 'Formado' AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarSituacaoAtualDiscenteSituacaoDiscente, curso.certif_portaria_credenciamento AS DadosDiplomaDadosCursoPortaria, inscricao.data_conclusao AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarSituacaoAtualDiscenteSituacaoDiscenteFormadoDataConclusaoCurso, inscricao.data_conclusao AS DadosDiplomaDataConclusao, diploma_mec_curso.nome_curso_mec AS DadosDiplomaDadosCursoNomeCurso, diploma_mec_curso.nome_habilitacao_mec AS DadosDiplomaDadosCursoNomeHabilitacao, diploma_mec_curso.codigo_curso_emec AS DadosDiplomaDadosCursoCodigoCursoEMEC, CASE curso.tipo_graduacao WHEN 'B' THEN 'Bacharelado'WHEN 'F' THEN 'Formação Pedagógica'WHEN 'L' THEN 'Licenciatura'WHEN 'S' THEN 'Segunda Licenciatura'WHEN 'T' THEN 'Tecnólogo'ELSE curso.tipo_graduacao END DadosDiplomaDadosCursoTituloConferidoOutroTitulo, CASE curso.tipo_graduacao WHEN 'B' THEN 'Bacharelado'WHEN 'F' THEN 'Curso sequencial'WHEN 'L' THEN 'Licenciatura 'WHEN 'S' THEN 'Licenciatura' WHEN 'T' THEN 'Tecnólogo'ELSE curso.tipo_graduacao END DadosDiplomaDadosCursoGrauConferido, CASE curso.tipo_curso WHEN 'E' THEN 'EAD'WHEN 'P' THEN 'Presencial'ELSE curso.tipo_curso END DadosDiplomaDadosCursoModalidade, diploma_mec_tipo_ato.tipo_ato AS DadosDiplomaDadosCursoAutorizacaoTipo, diploma_mec_curso.codigo_autorizacao AS DadosDiplomaDadosCursoAutorizacaoNumero, diploma_mec_ato_regulatorio.veiculo_publicacao AS DadosDiplomaDadosCursoAutorizacaoVeiculoPublicacao, diploma_mec_ato_regulatorio.data_ato AS DadosDiplomaDadosCursoAutorizacaoData, diploma_mec_ato_regulatorio.data_publicacao AS DadosDiplomaDadosCursoAutorizacaoDataPublicacao, diploma_mec_ato_regulatorio.secao_publicacao AS DadosDiplomaDadosCursoAutorizacaoSecaoPublicacao, diploma_mec_ato_regulatorio.pagina_publicacao AS DadosDiplomaDadosCursoAutorizacaoPaginaPublicacao, diploma_mec_ato_regulatorio.numero_dou AS DadosDiplomaDadosCursoAutorizacaoNumeroDOU, diploma_mec_tipo_ato.tipo_ato AS DadosDiplomaDadosCursoReconhecimentoTipo, diploma_mec_ato_regulatorio.numero_ato AS DadosDiplomaDadosCursoReconhecimentoNumero, diploma_mec_ato_regulatorio.veiculo_publicacao AS DadosDiplomaDadosCursoReconhecimentoVeiculoPublicacao, diploma_mec_ato_regulatorio.data_publicacao AS DadosDiplomaDadosCursoReconhecimentoDataPublicacao, diploma_mec_ato_regulatorio.secao_publicacao AS DadosDiplomaDadosCursoReconhecimentoSecaoPublicacao, diploma_mec_ato_regulatorio.pagina_publicacao AS DadosDiplomaDadosCursoReconhecimentoPaginaPublicacao, diploma_mec_ato_regulatorio.numero_dou AS DadosDiplomaDadosCursoReconhecimentoNumeroDOU, diploma_mec_endereco.endereco_logradouro AS DadosDiplomaDadosCursoEnderecoLogradouro, diploma_mec_endereco.endereco_numero AS DadosDiplomaDadosCursoEnderecoNumero, diploma_mec_endereco.endereco_complemento AS DadosDiplomaDadosCursoEnderecoComplemento, diploma_mec_endereco.endereco_bairro AS DadosDiplomaDadosCursoEnderecoBairro, diploma_mec_endereco.endereco_cep AS DadosDiplomaDadosCursoEnderecoCEP, diploma_mec_endereco.endereco_codigo_municipio AS DadosDiplomaDadosCursoEnderecoCodigoMunicipio, diploma_mec_endereco.endereco_nome_municipio AS DadosDiplomaDadosCursoEnderecoNomeMunicipio, diploma_mec_endereco.endereco_uf AS DadosDiplomaDadosCursoEnderecoUF, professor.nome_professor AS DocenteNome, CASE professor.titulacao_professor WHEN 'P' THEN 'Doutorado' WHEN 'E' THEN 'Especialização' WHEN 'M' THEN 'Mestrado' WHEN 'D' THEN 'Doutorado' END DocenteTitulacao, CONCAT(DATE_FORMAT(inscricao.data_conclusao, '%Y'),'/',IF(DATE_FORMAT(inscricao.data_conclusao, '%m')<6,'1','2')) AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularSituacaoDiscentePeriodoLetivo, 'FORMADO' AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularSituacaoDiscenteSituacaoDiscente FROM inscricao JOIN curso ON curso.codigo_curso = inscricao.codigo_curso JOIN diploma_mec_curso ON diploma_mec_curso.codigo_curso = inscricao.codigo_curso JOIN diploma_mec_ato_regulatorio ON diploma_mec_ato_regulatorio.codigo_ato_regulatorio = diploma_mec_curso.codigo_autorizacao JOIN diploma_mec_tipo_ato ON diploma_mec_tipo_ato.codigo_tipo_ato = diploma_mec_ato_regulatorio.codigo_tipo_ato JOIN professor ON professor.codigo_professor = curso.codigo_professor_responsavel JOIN diploma_mec_dados_ies ON diploma_mec_dados_ies.codigo_dados_ies = diploma_mec_curso.codigo_dados_ies JOIN diploma_mec_endereco ON diploma_mec_endereco.codigo_endereco = diploma_mec_dados_ies.codigo_endereco WHERE inscricao.codigo_inscricao = :cod AND inscricao.codigo_inscricao_situacao = 7");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function dadosCursoArea($cod){	
	    $stmt = $this->db->prepare("SELECT area_conhec_curso.codigo_curso, area_conhec_curso.codigo_area_conhec, area_conhec.codigo_area_conhec, area_conhec.nome_area_conhec AS DadosDiplomaDadosCursoArea FROM area_conhec_curso JOIN area_conhec ON area_conhec.codigo_area_conhec = area_conhec_curso.codigo_area_conhec where area_conhec_curso.codigo_curso = :cod limit 1");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function dadosEmissora($cod){
	    $stmt = $this->db->prepare("SELECT diploma_mec_dados_ies.codigo_mec AS DadosDiplomaIesEmissoraCodigoMEC, diploma_mec_dados_ies.nome_ies AS DadosDiplomaIesEmissoraNome, diploma_mec_dados_ies.cnpj_ies AS DadosDiplomaIesEmissoraCNPJ, diploma_mec_endereco.endereco_logradouro AS DadosDiplomaIesEmissoraEnderecoLogradouro, diploma_mec_endereco.endereco_numero AS DadosDiplomaIesEmissoraEnderecoNumero, diploma_mec_endereco.endereco_complemento AS DadosDiplomaIesEmissoraEnderecoComplemento, diploma_mec_endereco.endereco_bairro AS DadosDiplomaIesEmissoraEnderecoBairro, diploma_mec_endereco.endereco_cep AS DadosDiplomaIesEmissoraEnderecoCEP, diploma_mec_endereco.endereco_codigo_municipio AS DadosDiplomaIesEmissoraEnderecoCodigoMunicipio, diploma_mec_endereco.endereco_nome_municipio AS DadosDiplomaIesEmissoraEnderecoNomeMunicipio, diploma_mec_endereco.endereco_uf AS DadosDiplomaIesEmissoraEnderecoUF, diploma_mec_tipo_ato.tipo_ato AS DadosDiplomaIesEmissoraCredenciamentoTipo, diploma_mec_ato_regulatorio.numero_ato AS DadosDiplomaIesEmissoraCredenciamentoNumero, DATE_FORMAT(diploma_mec_ato_regulatorio.data_ato, '%Y-%m-%d') AS DadosDiplomaIesEmissoraCredenciamentoData, diploma_mec_ato_regulatorio.veiculo_publicacao AS DadosDiplomaIesEmissoraCredenciamentoVeiculoPublicacao, DATE_FORMAT(diploma_mec_ato_regulatorio.data_publicacao, '%Y-%m-%d') AS DadosDiplomaIesEmissoraCredenciamentoDataPublicacao, diploma_mec_ato_regulatorio.secao_publicacao AS DadosDiplomaIesEmissoraCredenciamentoSecaoPublicacao, diploma_mec_ato_regulatorio.pagina_publicacao AS DadosDiplomaIesEmissoraCredenciamentoPaginaPublicacao, diploma_mec_ato_regulatorio.numero_dou AS DadosDiplomaIesEmissoraCredenciamentoNumeroDOU FROM diploma_mec_dados_ies JOIN diploma_mec_endereco ON diploma_mec_endereco.codigo_endereco = diploma_mec_dados_ies.codigo_endereco JOIN diploma_mec_ato_regulatorio ON diploma_mec_ato_regulatorio.codigo_ato_regulatorio = diploma_mec_dados_ies.codigo_credenciamento JOIN diploma_mec_tipo_ato ON diploma_mec_tipo_ato.codigo_tipo_ato = diploma_mec_ato_regulatorio.codigo_tipo_ato WHERE diploma_mec_dados_ies.codigo_dados_ies = :cod LIMIT 1;");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function dadosMantenedora($cod){
	    $stmt = $this->db->prepare("SELECT diploma_mec_dados_ies.mantenedora_razao_social AS DadosDiplomaIesEmissoraMantenedoraRazaoSocial, diploma_mec_dados_ies.mantenedora_cnpj AS DadosDiplomaIesEmissoraMantenedoraCNPJ, diploma_mec_endereco.endereco_logradouro AS DadosDiplomaIesEmissoraMantenedoraEnderecoLogradouro, diploma_mec_endereco.endereco_numero AS DadosDiplomaIesEmissoraMantenedoraEnderecoNumero, diploma_mec_endereco.endereco_complemento AS DadosDiplomaIesEmissoraMantenedoraEnderecoComplemento, diploma_mec_endereco.endereco_bairro AS DadosDiplomaIesEmissoraMantenedoraEnderecoBairro, diploma_mec_endereco.endereco_cep AS DadosDiplomaIesEmissoraMantenedoraEnderecoCEP, diploma_mec_endereco.endereco_codigo_municipio AS DadosDiplomaIesEmissoraMantenedoraEnderecoCodigoMunicipio, diploma_mec_endereco.endereco_nome_municipio AS DadosDiplomaIesEmissoraMantenedoraEnderecoNomeMunicipio, diploma_mec_endereco.endereco_uf AS DadosDiplomaIesEmissoraMantenedoraEnderecoUF FROM diploma_mec_dados_ies JOIN diploma_mec_endereco ON diploma_mec_endereco.codigo_endereco = diploma_mec_dados_ies.mantenedora_codigo_endereco WHERE diploma_mec_dados_ies.codigo_dados_ies = :cod LIMIT 1;");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function dadosEstagios($cod){
	    $stmt = $this->db->prepare("SELECT estagio.codigo_estagio AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularEstagioCodigo, DATE_FORMAT(estagio.data_cadastro, '%Y-%m-%d') AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularEstagioDataInicio, DATE_FORMAT(estagio.data_avaliacao, '%Y-%m-%d') AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularEstagioDataFim, curso.codigo_curso AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularEstagioCargaHorariaHoraRelogio FROM inscricao JOIN curso ON curso.codigo_curso = inscricao.codigo_curso JOIN estagio ON estagio.codigo_inscricao = inscricao.codigo_inscricao WHERE inscricao.codigo_inscricao = :cod AND estagio.situacao_estagio = 'A';");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function dadosAtividades($cod){
        $stmt = $this->db->prepare("SELECT atividade_compl.codigo_atividade_compl AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularAtividadeComplementarCodigo, DATE_FORMAT(atividade_compl.data_cadastro, '%Y-%m-%d') AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularAtividadeComplementarDataInicio, DATE_FORMAT(atividade_compl.data_analise, '%Y-%m-%d') AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularAtividadeComplementarDataFim, atividade_compl.tipo_atividade AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularAtividadeComplementarTipoAtividadeComplementar, atividade_compl.horas_aceitas AS RegistroReqDadosPrivadosDiplomadoHistoricoEscolarMatrizCurricularAtividadeComplementarCargaHorariaHoraRelogio, professor.nome_professor AS DocenteNome, CASE professor.titulacao_professor WHEN 'P' THEN 'Pós-Doutor'WHEN 'E' THEN 'Especialista'WHEN 'M' THEN 'Mestre'WHEN 'D' THEN 'Doutor'END DocenteTitulacao FROM inscricao JOIN atividade_compl ON atividade_compl.codigo_inscricao = inscricao.codigo_inscricao JOIN usuario ON usuario.id = atividade_compl.codigo_usuario_analise JOIN professor ON professor.codigo_usuario = atividade_compl.codigo_usuario_analise WHERE inscricao.codigo_inscricao = :cod AND atividade_compl.situacao_atividade_compl = 'A';");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	public function dadosDocumentos($cod){
        $stmt = $this->db->prepare("SELECT prontuario.hash_arq_documento AS RegistroReqDocumentacaoComprobatoriaDocumentoDocumento, tipo_documento.codigo_tipo_documento AS RegistroReqDocumentacaoComprobatoriaDocumentoTipo, prontuario.amd_arq_documento AS LocalArquivo, arquivo.nome_arquivo AS NomeArquivo, arquivo.mime_type_arquivo AS MIMEArquivo FROM inscricao JOIN prontuario ON prontuario.codigo_inscricao = inscricao.codigo_inscricao JOIN tipo_documento ON tipo_documento.codigo_tipo_documento = prontuario.codigo_tipo_documento JOIN arquivo ON arquivo.hash_arquivo = prontuario.hash_arq_documento WHERE inscricao.codigo_inscricao = :cod AND prontuario.codigo_tipo_documento IN(1,2,5,6);");
		$stmt->bindValue( ':cod', $cod);
		$stmt->execute();
		$resultado=$stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}
	
	// Acesso
	
	public function acessoUsuarios($email,$password){
	    $stmt = $this->db->prepare("select codigo_acesso, nome_acesso, email_acesso, senha_acesso from diploma_mec_acesso where email_acesso = :email and senha_acesso = :password limit 1");
 		$stmt->bindparam( ':email', $email );
 		$stmt->bindparam( ':password', $password );
		$stmt->execute();
		$resultado=$stmt->fetch(PDO::FETCH_ASSOC);
		return $resultado;
	}
}
?>